-- Arrays aggregieren (wird erst mit 9.5 eingeführt).
-- keine Sortierung, kein Ausschluss von Dopplungen
DO $$
BEGIN

    IF ( tsystem.postgresqlVersion() >= 140 ) THEN

        CREATE AGGREGATE array_cat_agg( anycompatiblearray ) (
            SFUNC=array_cat,
            STYPE=anycompatiblearray
         );
    ELSE

        CREATE AGGREGATE array_cat_agg( anyarray ) (
            SFUNC=array_cat,
            STYPE=anyarray
         );
    END IF;
END $$;



--
--Variable Funktion, die über Tablename und Kunde gesteuert, firmenspezifisch/settingspezifisch Einträge in die Parameter der recnokeyword setzt
--Verwendung in Delphi, wenn firmenspezifische Parameter gesetzt werden sollen (set und reset) // r_descr und rvalue via Textnummer variabel halten
--Einsetzen, wenn unabhängig von INSERT TRIGGER
-- OFFEN --System Default NULL aufnehmen??
CREATE OR REPLACE FUNCTION set_recnoparam(rtablename VARCHAR, rdbrid VARCHAR, rdescr VARCHAR, rvalue VARCHAR, rnot BOOLEAN DEFAULT FALSE) RETURNS VOID AS $$
 BEGIN
  UPDATE recnokeyword SET r_not=rnot, r_value=rvalue WHERE r_tablename=rtablename AND r_dbrid=rdbrid AND r_descr=rdescr;
  --ACHTUNG r_not kann an dieser Stelle als NICHT oder schlichtes BOOL interpretiert werden, je nachdem wie man die Parameter setzt
  IF NOT FOUND THEN
    INSERT INTO recnokeyword(r_tablename, r_dbrid, r_descr, r_not, r_value) VALUES (rtablename, rdbrid, rdescr, rnot, rvalue);
  END IF;
  --
  RETURN;
 END $$ LANGUAGE plpgsql;  --ACHTUNG Beachte ebenso TRIGGER FUNCTION set_recnoparam() in A system

-- Auslesen eines Parameters zB.: SELECT (get_recnoparam('auftg', '72912421', lang_text(25082))).rvalue
CREATE OR REPLACE FUNCTION get_recnoparam(IN rtablename VARCHAR, IN rdbrid VARCHAR, INOUT rdescr VARCHAR, OUT rvalue VARCHAR, OUT rnot BOOLEAN, OUT rkategorie VARCHAR, OUT rtxt TEXT, OUT modby VARCHAR) RETURNS RECORD AS $$
 BEGIN
  SELECT r_value, r_not, r_kategorie, r_txt, r_descr, modified_by
  INTO rvalue, rnot, rkategorie, rtxt, rdescr, modby
  FROM recnokeyword WHERE r_tablename=rtablename AND r_dbrid=rdbrid AND r_descr=rdescr;
  --
  RETURN;
 END $$ LANGUAGE plpgsql;

--Löschen eines Parameters zB.: SELECT del_recnoparam('auftg', '72912421', lang_text(25082))
CREATE OR REPLACE FUNCTION del_recnoparam(IN rtablename VARCHAR, IN rdbrid VARCHAR, IN rdescr VARCHAR) RETURNS VOID AS $$
 BEGIN
  DELETE FROM recnokeyword WHERE r_tablename=rtablename AND r_dbrid=rdbrid AND r_descr=rdescr;
  --
  RETURN;
 END $$ LANGUAGE plpgsql;



CREATE OR REPLACE FUNCTION AsTimeStamp(IN _date date, IN _time varchar) RETURNS timestamp
  AS $$
  BEGIN
    BEGIN
      RETURN cast(_date || coalesce(' ' || _time, '') AS timestamp);
    EXCEPTION WHEN others THEN
      RETURN _date;
    END;
  END $$ LANGUAGE plpgsql;


-- Castet Text auf NUMERIC.
CREATE OR REPLACE FUNCTION AsNumeric(IN txt TEXT, IN NullToZero BOOLEAN DEFAULT FALSE, IN RaiseErrors BOOLEAN DEFAULT FALSE) RETURNS NUMERIC AS $$
 BEGIN
  --
  IF NullIF(txt,'') IS NULL THEN
    IF NULLtoZero THEN
      RETURN 0;
    ELSE
      RETURN NULL;
    END IF;
  END IF;

  txt := REPLACE(txt, ',', '.');

  IF RaiseErrors THEN
    RETURN txt :: NUMERIC;
  END IF;

  BEGIN
    RETURN $1::NUMERIC;
  EXCEPTION WHEN others THEN
     IF NULLtoZero THEN
      RETURN 0;
    ELSE
      RETURN NULL;
    END IF;
  END;

 END $$ LANGUAGE plpgsql IMMUTABLE;
--

-- funktion prüft, ob es sich bei _input um einen validen numerischen wert handelt
CREATE OR REPLACE FUNCTION IsNumeric( _input text, _exp_exclude boolean = true ) RETURNS boolean AS $$
  BEGIN

    IF _input = 'NaN'::numeric THEN
       RETURN false;
    END IF;

    PERFORM _input::numeric;

    IF    _exp_exclude
      AND position('e' in lower(_input)) > 0 THEN
      RETURN false;
    END IF;

    RETURN true;

    EXCEPTION WHEN others THEN -- TODO: AUSBAUEN SIEHE UNTEN
      RETURN false;

  -- Muss PARALEL UNSAFE deklariert sein, wegen Exception Block
  -- TODO: ab PG16 umbauen auf: https://www.postgresql.org/docs/devel/functions-info.html#FUNCTIONS-INFO-VALIDITY
  -- dann wieder PARALLEL SAFE sowie auch übergeordnete Function GetIntegerSetting PARALLEL SAFE
  END $$ LANGUAGE plpgsql IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION AsNumeric(stringNum VARCHAR) RETURNS NUMERIC AS $$
 DECLARE s VARCHAR;
 BEGIN
  S:=Replace(stringNum, ',', '.');
  IF IsNumeric(S) THEN
     RETURN S::NUMERIC;
  ELSE
     RETURN NULL;
  END IF;
 END $$ LANGUAGE plpgsql IMMUTABLE STRICT;

--Testet bisher nur auf Integer, nicht auf "richtige" Datum-Werte
CREATE OR REPLACE FUNCTION IsDATE(text) RETURNS BOOLEAN AS $$
 DECLARE x DATE;
 BEGIN
    x = $1::DATE;
    RETURN TRUE;
 EXCEPTION WHEN others THEN
    RETURN FALSE;
 END;
 $$ LANGUAGE plpgsql IMMUTABLE;

-- ?!? Wieso nicht LEAST? => Siehe SELECT MIN(-1,NULL) , MIN(1,NULL), LEAST(-1, NULL), LEAST(1, NULL)
CREATE OR REPLACE FUNCTION min(NUMERIC, NUMERIC) RETURNS NUMERIC AS $$
 BEGIN
  IF COALESCE($1,0)<COALESCE($2,0) THEN
         RETURN COALESCE($1,0);
  ELSE
         RETURN COALESCE($2,0);
  END IF;
 END $$ LANGUAGE plpgsql IMMUTABLE;

CREATE OR REPLACE FUNCTION createmessage(username VARCHAR, betreff VARCHAR, message TEXT) RETURNS VOID AS $$
 BEGIN
  INSERT INTO messages (m_for_user, m_mkind, m_message) VALUES ($1, $2, $3);
  RETURN;
 END $$ LANGUAGE plpgsql;
--

-- FieldAlias : FieldName wenn nicht gefunden
CREATE OR REPLACE FUNCTION GetFieldAlias(fieldname VARCHAR, fieldaliastablename VARCHAR DEFAULT NULL) RETURNS VARCHAR AS $$
  DECLARE result VARCHAR;
  BEGIN
    result:= prodat_languages.lang_text(fa_textno) FROM public.fieldalias WHERE UPPER(fa_fieldname)=UPPER(fieldname) AND COALESCE(UPPER(fa_tablename), '')=COALESCE(UPPER(fieldaliastablename),'') LIMIT 1;
    IF result IS NULL THEN
        result:= prodat_languages.lang_text(fa_textno) FROM public.fieldalias WHERE UPPER(fa_fieldname)=UPPER(fieldname) AND COALESCE(fa_tablename, '')='' LIMIT 1;
    END IF;
    RETURN COALESCE(result, COALESCE(fieldaliastablename||'.', '')||fieldname);
  END $$ LANGUAGE plpgsql STABLE;
--

-- FieldAlias : NULL wenn nicht gefunden
CREATE OR REPLACE FUNCTION GetFieldAliasE(fieldname VARCHAR, fieldaliastablename VARCHAR DEFAULT NULL) RETURNS VARCHAR AS $$
  DECLARE result VARCHAR;
  BEGIN
    result:= prodat_languages.lang_text(fa_textno) FROM public.fieldalias WHERE UPPER(fa_fieldname)=UPPER(fieldname) AND COALESCE(UPPER(fa_tablename), '')=COALESCE(UPPER(fieldaliastablename),'') LIMIT 1;
    IF result IS NULL THEN
        result:= prodat_languages.lang_text(fa_textno) FROM public.fieldalias WHERE UPPER(fa_fieldname)=UPPER(fieldname) AND COALESCE(fa_tablename, '')='' LIMIT 1;
    END IF;
    RETURN NULLIF(result, '');
  END $$ LANGUAGE plpgsql STABLE;
--

-- eindeutiger Schlüssel für jeden Satz der Datenbank
CREATE SEQUENCE db_id_seq;

--
CREATE OR REPLACE FUNCTION get_db_id() RETURNS VARCHAR AS $$
  SELECT nextval('db_id_seq')::VARCHAR;
  $$ LANGUAGE sql;
--


-- Terminwoche > ProdatCommon.WeekOfYear (termweek_to_date / ProdatCommon.TermWeekToDate)
CREATE OR REPLACE FUNCTION week_of_year(TermDate DATE, KWStyle BOOLEAN DEFAULT FALSE) RETURNS VARCHAR AS $$
  SELECT TSystem.IfThen(KWStyle, to_char(TermDate, '"KW" IY-IW'), to_char(TermDate, 'IYYYIW'));
  $$ LANGUAGE sql IMMUTABLE PARALLEL SAFE;

CREATE OR REPLACE FUNCTION last_day(DATE) RETURNS DATE AS $$
    SELECT (date_trunc('MONTH', $1) + INTERVAL '1 MONTH - 1 day')::DATE
  $$ LANGUAGE SQL IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION date__last_day_of_month__get(
    _date date
  ) RETURNS date AS $$
      SELECT ( date_trunc( 'month', _date ) + '1 month - 1 day'::interval )::date
  $$ LANGUAGE sql IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION date__first_day_of_month__get(
    _date  date
  ) RETURNS date AS $$
      SELECT date_trunc( 'month', _date )::date
  $$ LANGUAGE sql IMMUTABLE STRICT;


CREATE OR REPLACE FUNCTION week_of_month(p_date DATE, p_direction INTEGER DEFAULT 1) RETURNS INTEGER AS $$
    SELECT CASE WHEN $2 >= 0 THEN
      CEIL(EXTRACT(DAY FROM $1) / 7)::INTEGER
    ELSE
      0 - CEIL(
        (EXTRACT(DAY FROM last_day($1)) - EXTRACT(DAY FROM $1) + 1) / 7
      )::INTEGER
    END
  $$ LANGUAGE SQL IMMUTABLE;
--
/*Tag der Woche*/
CREATE OR REPLACE FUNCTION day_of_week(TIMESTAMP) RETURNS INTEGER AS $$
  SELECT EXTRACT(DOW FROM $1)::INTEGER;
  $$ LANGUAGE sql IMMUTABLE;

/*MonatUndJahr*/
-- Wandelt Timestamp in Integer um z.B 200409 für für September 2004
CREATE OR REPLACE FUNCTION date_to_yearmonth(TIMESTAMP) RETURNS INTEGER AS $$
  SELECT (EXTRACT(year FROM $1)*100+EXTRACT(month FROM $1))::INTEGER;
  $$ LANGUAGE sql IMMUTABLE;

-- Umkehrfunktion zu date_to_yearmonth mit Option für Ende des Monats
CREATE OR REPLACE FUNCTION yearmonth_to_date(yearmonth INTEGER, last_day BOOLEAN DEFAULT false) RETURNS DATE AS $$
  SELECT (to_date(yearmonth, 'YYYYMM') + CASE WHEN last_day THEN '1 month - 1 day' ELSE '0' END::INTERVAL)::DATE;
  $$ LANGUAGE sql IMMUTABLE;

-- wie vorherige Funktion, nur um 1 dekremented!!
CREATE OR REPLACE FUNCTION date_to_yearmonth_dec(TIMESTAMP) RETURNS INTEGER AS $$
  SELECT (EXTRACT(year FROM $1)*100+EXTRACT(month FROM $1)-1)::INTEGER;
  $$ LANGUAGE sql IMMUTABLE;

-- Umkehrfunktion zu date_to_yearmonth_dec mit Option für Ende des Monats
CREATE OR REPLACE FUNCTION yearmonth_dec_to_date(yearmonth_dec INTEGER, last_day BOOLEAN DEFAULT false) RETURNS DATE AS $$
  SELECT yearmonth_to_date(yearmonth_dec + 1, last_day);
  $$ LANGUAGE sql IMMUTABLE;

CREATE OR REPLACE FUNCTION year_of_date(DATE) RETURNS INTEGER AS $$
  SELECT extract(year FROM $1)::INTEGER;
  $$ LANGUAGE sql IMMUTABLE;

CREATE OR REPLACE FUNCTION year_week(DATE) RETURNS VARCHAR(10) AS $$
  SELECT to_char( $1,'IYYY "W" IW' );
  $$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION year_quarter(DATE) RETURNS VARCHAR(10) AS $$
  SELECT to_char( $1,'YYYY "Q" 0Q' );
  $$ LANGUAGE sql IMMUTABLE;

CREATE OR REPLACE FUNCTION year_month(DATE) RETURNS VARCHAR(10) AS $$
  SELECT to_char( $1,'YYYY M MM' );
  $$ LANGUAGE sql IMMUTABLE;

--Industrieminuten in Echtminuten konvertieren: 1,5h = 1:30
CREATE OR REPLACE FUNCTION realminute(NUMERIC) RETURNS VARCHAR(10) AS $$
    BEGIN
     RETURN sign($1) * (abs($1) * INTERVAL '1 hour'::TIME);
     --sign korrigiert abs... da -0.5h, sonst -23:30 ..daher auch Ausgabe als VARCHAR
     --Eine Konvertierung mit to_char(berechnung,'HH24:MI') rundet falsch, wäre aber schöner
    END$$LANGUAGE plpgsql IMMUTABLE;
--

-- Terminwoche
CREATE OR REPLACE FUNCTION termweek(TIMESTAMP) RETURNS INTEGER AS $$
  SELECT public.week_of_year(CAST($1 AS DATE))::INTEGER;
  $$ LANGUAGE sql IMMUTABLE PARALLEL SAFE;
--

-- Terminwoche KW
CREATE OR REPLACE FUNCTION termweek_kw(TIMESTAMP) RETURNS VARCHAR AS $$
  SELECT public.week_of_year(CAST($1 AS DATE), True);
  $$ LANGUAGE sql IMMUTABLE PARALLEL SAFE;
--

-- "YYYYWW" zu Datum > ProdatCommon.TermWeekToDate (week_of_year / ProdatCommon.WeekOfYear)
CREATE OR REPLACE FUNCTION termweek_to_date(TermWeek VARCHAR, WeekStart BOOLEAN DEFAULT false, Sunday BOOLEAN DEFAULT false) RETURNS DATE AS $$
  BEGIN
    BEGIN
        IF COALESCE(TermWeek, '') = '' THEN
            --TermWeek := week_of_year(current_date);
            RETURN NULL;  -- verhalten der alten SQL-Funktion (prodatseitig war es andersrum)
        END IF;
        RETURN
            to_date(regexp_replace(trim(TermWeek), '00$', '01'), 'IYYYIW')  -- replace: KW 00 abfangen > ist immer 01.01.
            + CASE WHEN WeekStart THEN 0  -- Montag
                   WHEN Sunday    THEN 6  -- Sonntag
                   ELSE                4  -- Freitag
              END;
    EXCEPTION
        WHEN others THEN RETURN NULL;
    END;
  END $$ LANGUAGE plpgsql IMMUTABLE;
--

-- Termweek zu Datum
CREATE OR REPLACE FUNCTION termweek_to_date(TermWeek INTEGER, WeekStart BOOLEAN DEFAULT false, Sunday BOOLEAN DEFAULT false) RETURNS DATE AS $$
   SELECT termweek_to_date($1::VARCHAR, $2, $3);
   $$ LANGUAGE sql IMMUTABLE;
--

-- Zeitdifferenz
CREATE OR REPLACE FUNCTION timediff(TIMESTAMP, TIMESTAMP) RETURNS NUMERIC AS $$
  DECLARE _anf TIMESTAMP(0);
          _end TIMESTAMP(0);
  BEGIN
    _anf:=$1;
    _end:=$2;
    IF (CAST(_end AS TIME)='23:59:59') AND NOT (CAST(_anf AS TIME)='00:00:00') THEN
        _anf:=CAST(_anf AS DATE)+CAST(_anf AS TIME)-CAST('00:00:01' AS TIME); -- wenn vergessen wurde abzustempeln
    END IF;
    RETURN EXTRACT(EPOCH FROM _end-_anf)/3600;
  END $$ LANGUAGE plpgsql IMMUTABLE STRICT;
--
CREATE OR REPLACE FUNCTION timediff(TIME, TIME) RETURNS NUMERIC AS $$
  DECLARE _anf TIME(0);
          _end TIME(0);
  BEGIN
    _anf:=$1;
    _end:=$2;
    IF (_end='23:59:59') AND NOT (_anf='00:00:00') THEN
        _anf:=_anf-CAST('00:00:01' AS TIME);
    END IF;
    RETURN EXTRACT(EPOCH FROM _end-_anf)/3600;
  END $$ LANGUAGE plpgsql IMMUTABLE STRICT;
--
CREATE OR REPLACE FUNCTION extract_time(TIMESTAMP WITHOUT TIME ZONE) RETURNS TIME AS $$
  BEGIN
    RETURN CAST(date_trunc('seconds', $1) AS TIME);
  END $$ LANGUAGE plpgsql IMMUTABLE;
--
CREATE OR REPLACE FUNCTION timediff(in week VARCHAR, in _d DATE) RETURNS INTEGER AS $$
  DECLARE I Integer;
          _md DATE;
  BEGIN
    I:=0;
    _md:=_d;
    WHILE CAST(termweek(_md-I) AS VARCHAR)>week LOOP
        I:=I+1;
    END LOOP;
    WHILE CAST(termweek(_md-I) AS VARCHAR)<week LOOP
        I:=I-1;
    END LOOP;
    RETURN I;
  END $$ LANGUAGE plpgsql IMMUTABLE STRICT;
-- Zeit-Differenz zwischen 2 Daten (substWE: Wochenenden rausnehmen,  substFT: Feiertage rausnehmen))
CREATE OR REPLACE FUNCTION timediff(in _danf DATE, in _dend DATE, substWE BOOLEAN DEFAULT FALSE, substFT BOOLEAN DEFAULT FALSE, span BOOLEAN DEFAULT FALSE) RETURNS INTEGER AS $$
  DECLARE days INTEGER; -- Anzahl Differenz in Tagen
          corr_day INTEGER; -- Korrektur-Tag
          direction SMALLINT;
          switch_date DATE;
  BEGIN
    direction:=sign(_dend-_danf);
    -- wenn Ende jünger als Anfang ist.
    IF direction = -1 THEN
        switch_date:= _danf;
        _danf:= _dend;
        _dend:= switch_date;
    END IF;

    -- Ausnahmebehandlung timespan Zeitspanne im Unterschied zu timediff Differenz von Tagen
    IF span AND direction = 0 THEN -- Für Zeitspanne 1 Tag wird sonst im Return alles 0
        direction = 1;
    END IF;

    -- Berechnet man die Differenz oder die Spanne #20357
    IF span THEN
        corr_day = 0; -- bei Urlaub benötigen wir 00:00 bis 24:00 ohne Abzug
    ELSE
        corr_day = 1; -- bei einer Differenz von Tagen nehmen, ziehen wir 1 Tag ab
    END IF;

    -- Anzahl der Tage (ggf. ohne WE)
    SELECT count(1) - corr_day
    INTO days
    FROM generate_series(_danf, _dend, '1 day')
    WHERE (EXTRACT(dow FROM generate_series) NOT IN (0, 6) -- WE ausschließen
           OR NOT substWE);

    IF substFT THEN
        days:= days - (SELECT count(1) FROM feiertag
                       WHERE NOT ft_urlaub
                         AND ft_date BETWEEN _danf AND _dend
                         AND (EXTRACT(dow FROM ft_date) NOT IN (0, 6) -- WE evtl. schon ausgeschlossen, nicht nochmal abziehen.
                              OR NOT substWE)
                       );
    END IF;

    RETURN days*direction;
  END $$ LANGUAGE plpgsql STABLE STRICT;
-- Zeit-Differenz Tage vor oder zurück (substWE: Wochenenden rausnehmen,  substFT: Feiertage rausnehmen)
-- TODO AXS: Funktion mMn fehlerhaft: Berechnet einen Tag zu wenig (bei Beginn am WE). Ggf. Berichtigen!
CREATE OR REPLACE FUNCTION timediff_addsubstdays(in _danf TIMESTAMP, in addsubstdays NUMERIC, substWE BOOLEAN DEFAULT FALSE, substFT BOOLEAN DEFAULT FALSE) RETURNS TIMESTAMP AS $$
  DECLARE end_date  TIMESTAMP;
          day_step  INTERVAL;
          i         INTEGER;
          feiertage DATE[];
  BEGIN
    IF _danf IS NULL OR COALESCE(addsubstdays::INTEGER, 0) = 0 THEN
        RETURN _danf;
    END IF;

    end_date:= _danf;
    day_step:= sign(addsubstdays) * '1 day'::INTERVAL; -- Tag vorwärts oder rückwärts. Richtung bei 0 nicht entscheidbar.

    IF substWE OR substFT THEN
        IF substFT THEN -- Performance: Feiertage nicht per EXISTS pro Tag, sondern Array
            feiertage:= (SELECT array_agg(ft_date) FROM feiertag
                         WHERE NOT ft_urlaub
                           AND CASE WHEN sign(addsubstdays) = -1 THEN
                                    ft_date BETWEEN date_trunc('year', _danf::DATE - abs(addsubstdays::INTEGER) - '1 year'::INTERVAL)::DATE AND _danf::DATE -- wenn rückwärts Feiertag des vorigen Jahres bis heute in Array
                               ELSE ft_date BETWEEN _danf::DATE AND date_trunc('year', _danf::DATE + abs(addsubstdays::INTEGER) + '2 year'::INTERVAL)::DATE -- wenn vorwärts Feiertag bis Ende des nächsten Jahres in Array
                               END);
        END IF;

        FOR i IN 1 .. abs(addsubstdays::INTEGER) LOOP -- bei 1 .. 0 kein LOOP
            end_date:= end_date + day_step;
            -- Muss im WHILE immer auf WE oder Feiertag geprüft werden, da Folgetag das jeweils andere sein kann.
            WHILE (substWE AND EXTRACT(dow FROM end_date) IN (0, 6)) -- Prüfung WE
                  OR
                  (substFT AND end_date::DATE = ANY(feiertage)) -- Prüfung Feiertag
            LOOP
                end_date:= end_date + day_step;
            END LOOP;
        END LOOP;
    ELSE
        end_date:= end_date + addsubstdays::INTEGER * '1 day'::INTERVAL;
    END IF;

    RETURN end_date;
  END $$ LANGUAGE plpgsql STABLE;
-- Zeit-Differenz Tage vorwärts (substWE: Wochenenden rausnehmen,  substFT: Feiertage rausnehmen)
CREATE OR REPLACE FUNCTION timediff_adddays(in _danf TIMESTAMP, in substdays NUMERIC, substWE BOOLEAN DEFAULT FALSE, substFT BOOLEAN DEFAULT FALSE) RETURNS TIMESTAMP AS $$
  BEGIN
    IF COALESCE(substdays::INTEGER, 0) = 0 THEN
        -- Wir wollen zwar 0 Tage vorwärts, aber Option "Kein WE" oder "Kein Feiertag" ist an und der Anfangstag ist ein solcher.
        IF (substWE AND EXTRACT(dow FROM _danf) IN (0, 6)) -- Prüfung WE
           OR
           (substFT AND EXISTS(SELECT true FROM public.feiertag WHERE NOT ft_urlaub AND ft_date = _danf::DATE)) -- Prüfung Feiertag
        THEN
            RETURN timediff_addsubstdays(_danf, 1, substWE, substFT);
        END IF;
    END IF;
    RETURN timediff_addsubstdays(_danf, substdays, substWE, substFT);
  END $$ LANGUAGE plpgsql STABLE;
-- Zeit-Differenz Tage rückwärts (substWE: Wochenenden rausnehmen,  substFT: Feiertage rausnehmen)
CREATE OR REPLACE FUNCTION timediff_substdays(in _danf TIMESTAMP, in substdays NUMERIC, substWE BOOLEAN DEFAULT FALSE, substFT BOOLEAN DEFAULT FALSE) RETURNS TIMESTAMP AS $$
  BEGIN
    IF COALESCE(substdays::INTEGER, 0) = 0 THEN
        -- Wir wollen zwar 0 Tage rückwärts, aber Option "Kein WE" oder "Kein Feiertag" ist an und der Anfangstag ist ein solcher.
        IF (substWE AND EXTRACT(dow FROM _danf) IN (0, 6)) -- Prüfung WE
           OR
           (substFT AND EXISTS(SELECT true FROM public.feiertag WHERE NOT ft_urlaub AND ft_date = _danf::DATE)) -- Prüfung Feiertag
        THEN
            RETURN timediff_addsubstdays(_danf, -1, substWE, substFT);
        END IF;
    END IF;
    RETURN timediff_addsubstdays(_danf, -substdays, substWE, substFT);
  END $$ LANGUAGE plpgsql STABLE;
--
CREATE OR REPLACE FUNCTION dayNameOfWeek (date Date) RETURNS VARCHAR(15) AS $$
 DECLARE
  DAY_OF_WEEK_CONST VARCHAR(15) := 'dow';
  dayOfWeek Integer := 0;
  dayName VARCHAR(15) := 'dayNameOfWeek';
 BEGIN
   dayOfWeek := date_part(DAY_OF_WEEK_CONST, Date);
      IF dayOfWeek = 0 THEN
      dayName := lang_text(17);   --'Sonntag';
      ELSEIF dayOfWeek = 1 THEN
      dayName := lang_text(18);   --'Montag';
      ELSEIF dayOfWeek = 2 THEN
      dayName := lang_text(19);   --'Dienstag';
      ELSEIF dayOfWeek = 3 THEN
      dayName := lang_text(20);   --'Mittwoch';
      ELSEIF dayOfWeek = 4 THEN
      dayName := lang_text(21);   --'Donnerstag';
      ELSEIF dayOfWeek = 5 THEN
      dayName := lang_text(22);   --'Freitag';
      ELSEIF dayOfWeek = 6 THEN
      dayName := lang_text(23);   --'Samstag';
      END IF;
   RETURN dayName;
 END $$ LANGUAGE plpgsql STABLE STRICT PARALLEL SAFE;


 /*SELECT TSystem.Create_FComment(
      'getMonthName'
     ,'Ausgeschriebenen Monat zu einer Monatsnummer',
     ,'1=>Januar'
     ,ARRAY['monthnr']
     ,ARRAY['MonatNummer']
     ,ARRAY['Datum','Monat']
     );*/

CREATE OR REPLACE FUNCTION getMonthName(monthnr INTEGER) RETURNS VARCHAR(15) AS $$
 DECLARE monthName VARCHAR(15) := 'n.a.';
 BEGIN
      IF monthnr = 1 THEN
      monthName := lang_text(4);    --'Januar';
      ELSEIF monthnr = 2 THEN
      monthName := lang_text(5);    --'Februar';
      ELSEIF monthnr = 3 THEN
      monthName := lang_text(6);    --'M'||chr(228)||'rz'; --Umlaut mitnehmen
      ELSEIF monthnr = 4 THEN
      monthName := lang_text(7);    --'April';
      ELSEIF monthnr = 5 THEN
      monthName := lang_text(8);    --'Mai';
      ELSEIF monthnr = 6 THEN
      monthName := lang_text(9);    --'Juni';
      ELSEIF monthnr = 7 THEN
      monthName := lang_text(10);   --'Juli';
      ELSEIF monthnr = 8 THEN
      monthName := lang_text(11);   --'August';
      ELSEIF monthnr = 9 THEN
      monthName := lang_text(12);   --'September';
      ELSEIF monthnr = 10 THEN
      monthName := lang_text(13);   --'Oktober';
      ELSEIF monthnr = 11 THEN
      monthName := lang_text(14);   --'November';
      ELSEIF monthnr = 12 THEN
      monthName := lang_text(15);   --'Dezember';
      END IF;
  RETURN monthName;
 END;$$ LANGUAGE plpgsql IMMUTABLE STRICT;
--

--
CREATE OR REPLACE FUNCTION today()
  RETURNS date
  AS $$
     SELECT current_date;
  $$ LANGUAGE sql STABLE;
--

-- Intervalle übersetzen
CREATE OR REPLACE FUNCTION getIntervalName(IN inInterval INTERVAL) RETURNS VARCHAR(100) AS $$
 DECLARE secs    INTEGER;
        mins    INTEGER;
        hours   INTEGER;
        days    INTEGER;
        months  INTEGER;
        years   INTEGER;
        str     VARCHAR;
 BEGIN
        str:='';
        secs:=          EXTRACT(second FROM inInterval)::INTEGER;
        mins:=          EXTRACT(minute FROM inInterval)::INTEGER;
        hours:=         EXTRACT(hour FROM inInterval)::INTEGER;
        days:=          EXTRACT(day FROM inInterval)::INTEGER;
        months:=        EXTRACT(month FROM inInterval)::INTEGER;
        years:=         EXTRACT(year FROM inInterval)::INTEGER;

        IF years > 0    THEN str:= years || ' ' || lang_text(16235);                    END IF;
        IF months > 0   THEN str:= str || ' ' || months || ' ' || lang_text(16234);     END IF;
        IF days > 0     THEN str:= str || ' ' || days || ' ' || lang_text(16233);       END IF;
        IF hours > 0    THEN str:= str || ' ' || hours || ' ' || lang_text(16231);      END IF;
        IF mins > 0     THEN str:= str || ' ' || mins || ' ' || lang_text(16230);       END IF;
        IF secs > 0     THEN str:= str || ' ' || secs || ' ' || lang_text(16229);       END IF;

        str:=TRIM(str);
    RETURN str;
 END $$ LANGUAGE plpgsql;
--


-- rechnet ein Interval in Stunden um
CREATE OR REPLACE FUNCTION interval_to_hours(inValue INTERVAL) RETURNS numeric AS $$
 BEGIN
  RETURN EXTRACT(EPOCH FROM inValue) / EXTRACT(EPOCH FROM INTERVAL '1 hour');
 END $$ LANGUAGE plpgsql STABLE;
--

-- rechnet ein Interval in Tage um - EXTRACT(DAY FROM INTERVAL '1 years 2 mons 5 days 1 hours') gibt nur "die" 5 aus
CREATE OR REPLACE FUNCTION interval_to_days(inValue INTERVAL) RETURNS numeric AS $$
 BEGIN
  RETURN EXTRACT(EPOCH FROM inValue) / EXTRACT(EPOCH FROM INTERVAL '1 day');
 END $$ LANGUAGE plpgsql STABLE;
--
-- siehe I bde.sql
-- SQL-Funktion muss nach Tabellen-Definition erstellt werden
-- Zeit-Differenz (substWE=Wochenenden rausnehmen / substFT=Feiertage rausnehmen)
-- FUNCTION timediff(in _danf DATE, in _dend DATE, substWE BOOLEAN, substFT BOOLEAN) RETURNS INTEGER

--
CREATE OR REPLACE FUNCTION disableauftgtrigger_get() RETURNS INTEGER AS $$
    DECLARE varname VARCHAR;
            curvalue INTEGER;
    BEGIN
     IF current_user='syncro' THEN
            RETURN 0;
     END IF;
     varname:='auftg_disabled.'||current_user;
     curvalue:=COALESCE(NullIf(current_setting(varname, true),'')::INTEGER, 0); --Bestandswert holen
     PERFORM set_config(varname, (curvalue + 1)::VARCHAR, False);
     --PERFORM TSystem.Settings__Set(varname, CAST(TSystem.Settings__GetInteger(varname)+1 AS VARCHAR));
     PERFORM disablemodified();
     RETURN curvalue+1;--wir haben den alten Bestandswert
    END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION disableauftgtrigger() RETURNS VOID AS $$
    BEGIN
     PERFORM disableauftgtrigger_get();
     RETURN;
    END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION enableauftgtrigger_get() RETURNS INTEGER AS $$
    DECLARE varname VARCHAR;
            curvalue INTEGER;
    BEGIN
     IF current_user='syncro' THEN
            RETURN 0;
     END IF;
     varname:='auftg_disabled.'||current_user;
     curvalue:=COALESCE(NullIf(current_setting(varname, true),'')::INTEGER, 0);
     IF curvalue=0 THEN
        RAISE EXCEPTION 'enableauftgtrigger fails curvalue 0';
     END IF;
     PERFORM set_config(varname, (curvalue - 1)::VARCHAR, False);
     --PERFORM TSystem.Settings__Set(varname, CAST(TSystem.Settings__GetInteger(varname)-1 AS VARCHAR));
     PERFORM enablemodified();
     RETURN curvalue-1;--wir haben den alten Bestandswert
    END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION enableauftgtrigger() RETURNS VOID AS $$
    BEGIN
     PERFORM enableauftgtrigger_get();
     RETURN;
    END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION auftgtriggerdisabled() RETURNS BOOL AS $$
    DECLARE varname VARCHAR;
            curvalue INTEGER;
    BEGIN
     varname:='auftg_disabled.'||current_user;
     curvalue:=COALESCE(NullIf(current_setting(varname, true),'')::INTEGER, 0);
     IF curvalue<0 THEN
        RAISE EXCEPTION 'auftgtriggerdisabled fails curvalue <0';
     END IF;
     RETURN curvalue>0;
     --RETURN TSystem.Settings__GetInteger(varname)>0;
    END$$LANGUAGE plpgsql;

--
CREATE OR REPLACE FUNCTION disableauftgtrigger_totalposwertsubpos() RETURNS VOID AS $$
    DECLARE varname VARCHAR;
    BEGIN
     IF current_user='syncro' THEN
            RETURN;
     END IF;
     varname:=current_user||'auftg_disabled_totalposwertsubpos';
     PERFORM TSystem.Settings__Set(varname, CAST(TSystem.Settings__GetInteger(varname)+1 AS VARCHAR));
     PERFORM disablemodified();
     RETURN;
    END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION enableauftgtrigger_totalposwertsubpos() RETURNS VOID AS $$
    DECLARE varname VARCHAR;
    BEGIN
     IF current_user='syncro' THEN
            RETURN;
     END IF;
     varname:=current_user||'auftg_disabled_totalposwertsubpos';
     PERFORM TSystem.Settings__Set(varname, CAST(TSystem.Settings__GetInteger(varname)-1 AS VARCHAR));
     PERFORM enablemodified();
     RETURN;
    END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION auftgtriggerdisabled_totalposwertsubpos() RETURNS BOOL AS $$
    DECLARE varname VARCHAR;
    BEGIN
     varname:=current_user||'auftg_disabled_totalposwertsubpos';
     RETURN TSystem.Settings__GetInteger(varname)>0;
    END$$LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION disableauftgtrigger_subpostotalposwert() RETURNS VOID AS $$
    DECLARE varname VARCHAR;
    BEGIN
     IF current_user='syncro' THEN
            RETURN;
     END IF;
     varname:=current_user||'auftg_disabled_subpostotalposwert';
     PERFORM TSystem.Settings__Set(varname, CAST(TSystem.Settings__GetInteger(varname)+1 AS VARCHAR));
     PERFORM disablemodified();
     RETURN;
    END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION enableauftgtrigger_subpostotalposwert() RETURNS VOID AS $$
    DECLARE varname VARCHAR;
    BEGIN
     IF current_user='syncro' THEN
            RETURN;
     END IF;
     varname:=current_user||'auftg_disabled_subpostotalposwert';
     PERFORM TSystem.Settings__Set(varname, CAST(TSystem.Settings__GetInteger(varname)-1 AS VARCHAR));
     PERFORM enablemodified();
     RETURN;
    END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION auftgtriggerdisabled_subpostotalposwert() RETURNS BOOL AS $$
    DECLARE varname VARCHAR;
    BEGIN
     varname:=current_user||'auftg_disabled_subpostotalposwert';
     RETURN TSystem.Settings__GetInteger(varname)>0;
    END$$LANGUAGE plpgsql;

--
CREATE OR REPLACE FUNCTION disablestvtrstrigger() RETURNS VOID AS $$
    DECLARE varname VARCHAR;
    BEGIN
     IF current_user='syncro' THEN
            RETURN;
     END IF;
     varname:='stvtrs_disabled.'||current_user;
     PERFORM set_config(varname, (COALESCE(NullIf(current_setting(varname, true),'')::INTEGER, 0) - 1)::VARCHAR, False);
     --PERFORM TSystem.Settings__Set(varname, TSystem.Settings__GetInteger(varname)+1);
     PERFORM disablemodified();
     RETURN;
    END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION enablestvtrstrigger() RETURNS VOID AS $$
    DECLARE varname VARCHAR;
    BEGIN
     IF current_user='syncro' THEN
            RETURN;
     END IF;
     varname:='stvtrs_disabled.'||current_user;
     PERFORM set_config(varname, (COALESCE(NullIf(current_setting(varname, true),'')::INTEGER, 0) + 1)::VARCHAR, False);
     --PERFORM TSystem.Settings__Set(varname, TSystem.Settings__GetInteger(varname)-1);
     PERFORM enablemodified();
     RETURN;
    END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION stvtrstriggerdisabled() RETURNS BOOL AS $$
    DECLARE varname VARCHAR;
    BEGIN
     varname:='stvtrs_disabled.'||current_user;
     RETURN COALESCE(NullIf(current_setting(varname, true),'')::INTEGER, 0)>0;
     --RETURN TSystem.Settings__GetInteger(varname)>0;
    END$$LANGUAGE plpgsql;
--
CREATE OR REPLACE FUNCTION disablebelzeiltrigger() RETURNS VOID AS $$
    DECLARE varname VARCHAR;
    BEGIN
     IF current_user='syncro' THEN
            RETURN;
     END IF;
     varname:=current_user||'belzeil_disabled';
     PERFORM TSystem.Settings__Set(varname, CAST(TSystem.Settings__GetInteger(varname)+1 AS VARCHAR));
     PERFORM disablemodified();
     RETURN;
    END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION enablebelzeiltrigger() RETURNS VOID AS $$
    DECLARE varname VARCHAR;
    BEGIN
     IF current_user='syncro' THEN
            RETURN;
     END IF;
     varname:=current_user||'belzeil_disabled';
     PERFORM TSystem.Settings__Set(varname, CAST(TSystem.Settings__GetInteger(varname)-1 AS VARCHAR));
     PERFORM enablemodified();
     RETURN;
    END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION belzeiltriggerdisabled() RETURNS BOOL AS $$
    DECLARE varname VARCHAR;
    BEGIN
     varname:=current_user||'belzeil_disabled';
     RETURN TSystem.Settings__GetInteger(varname)>0;
    END$$LANGUAGE plpgsql;



--
CREATE OR REPLACE FUNCTION disablebelzeiltrigger_totalposwertsubpos() RETURNS VOID AS $$
    DECLARE varname VARCHAR;
    BEGIN
     IF current_user='syncro' THEN
            RETURN;
     END IF;
     varname:=current_user||'belzeil_disabled_totalposwertsubpos';
     PERFORM TSystem.Settings__Set(varname, CAST(TSystem.Settings__GetInteger(varname)+1 AS VARCHAR));
     PERFORM disablemodified();
     RETURN;
    END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION enablebelzeiltrigger_totalposwertsubpos() RETURNS VOID AS $$
    DECLARE varname VARCHAR;
    BEGIN
     IF current_user='syncro' THEN
            RETURN;
     END IF;
     varname:=current_user||'belzeil_disabled_totalposwertsubpos';
     PERFORM TSystem.Settings__Set(varname, CAST(TSystem.Settings__GetInteger(varname)-1 AS VARCHAR));
     PERFORM enablemodified();
     RETURN;
    END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION belzeiltriggerdisabled_totalposwertsubpos() RETURNS BOOL AS $$
    DECLARE varname VARCHAR;
    BEGIN
     varname:=current_user||'belzeil_disabled_totalposwertsubpos';
     RETURN TSystem.Settings__GetInteger(varname)>0;
    END$$LANGUAGE plpgsql;
--
CREATE OR REPLACE FUNCTION disablemodified() RETURNS VOID AS $$
    DECLARE varname VARCHAR;
    BEGIN
     IF current_user='syncro' THEN
            RETURN;
     END IF;
     varname:='modified_disabled.'||current_user;
     PERFORM set_config(varname, (COALESCE(NullIf(current_setting(varname, true),'')::INTEGER, 0) + 1)::VARCHAR, True);
     --PERFORM TSystem.Settings__Set(varname, TSystem.Settings__GetInteger(varname)+1);
     RETURN;
    END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION enablemodified() RETURNS VOID AS $$
    DECLARE varname VARCHAR;
    BEGIN
     IF current_user='syncro' THEN
            RETURN;
     END IF;
     varname:='modified_disabled.'||current_user;
     PERFORM set_config(varname, (COALESCE(NullIf(current_setting(varname, true),'')::INTEGER, 0) - 1)::VARCHAR, True);
     --PERFORM TSystem.Settings__Set(varname, TSystem.Settings__GetInteger(varname)-1);
     RETURN;
    END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION modifieddisabled() RETURNS BOOL AS $$
    DECLARE varname VARCHAR;
    BEGIN
     varname:='modified_disabled.'||current_user;
     RETURN COALESCE(NullIf(current_setting(varname, true),'')::INTEGER, 0)>0;
     --RETURN TSystem.Settings__GetInteger(varname)>0;
    END$$LANGUAGE plpgsql;

--Bedarfsberechnung an/abschalten
 CREATE OR REPLACE FUNCTION disablebedarfberech() RETURNS VOID AS $$
    DECLARE varname VARCHAR;
    BEGIN
     IF current_user='syncro' THEN
            RETURN;
     END IF;
     varname:='bedarfberech_disabled.'||current_user;
     PERFORM set_config(varname, (COALESCE(NullIf(current_setting(varname, true),'')::INTEGER, 0) + 1)::VARCHAR, True);
     --PERFORM TSystem.Settings__Set(varname, TSystem.Settings__GetInteger(varname)+1);
     PERFORM disablemodified();
     RETURN;
    END $$ LANGUAGE plpgsql;

 CREATE OR REPLACE FUNCTION enablebedarfberech() RETURNS VOID AS $$
    DECLARE varname VARCHAR;
    BEGIN
     IF current_user='syncro' THEN
            RETURN;
     END IF;
     varname:='bedarfberech_disabled.'||current_user;
     PERFORM set_config(varname, (COALESCE(NullIf(current_setting(varname, true),'')::INTEGER, 0) - 1)::VARCHAR, True);
     PERFORM enablemodified();
     RETURN;
    END $$ LANGUAGE plpgsql;

 CREATE OR REPLACE FUNCTION bedarfberechdisabled() RETURNS BOOL AS $$
    DECLARE varname VARCHAR;
    BEGIN
     varname:='bedarfberech_disabled.'||current_user;
     RETURN COALESCE(NullIf(current_setting(varname, true),'')::INTEGER, 0)>0;
     --RETURN TSystem.Settings__GetInteger(varname)>0;
    END$$LANGUAGE plpgsql;


/*Kurs*/
CREATE OR REPLACE FUNCTION waerkurs(VARCHAR) RETURNS NUMERIC AS $$
    BEGIN
     RETURN wa_kurs FROM bewa WHERE wa_einh=$1;
    END$$LANGUAGE plpgsql STABLE;

/*timestamp to date für Indexe*/
CREATE OR REPLACE FUNCTION timestamp_to_date(TIMESTAMP) RETURNS DATE AS $$
    BEGIN
     RETURN CAST($1 AS DATE);
    END$$LANGUAGE plpgsql IMMUTABLE;

--Bemerkungsverwaltung
CREATE OR REPLACE FUNCTION belarzu__zu_tit__gettxt(ident VARCHAR, lang VARCHAR DEFAULT prodat_languages.curr_lang(), getrtf BOOLEAN DEFAULT TRUE) RETURNS TEXT AS $$
    BEGIN
     IF getrtf THEN
            RETURN txtrtf FROM belarzu__zu_tit__gettxtrtf(ident, lang);
     ELSE
            RETURN txt FROM belarzu__zu_tit__gettxtrtf(ident, lang);
     END IF;
    END$$LANGUAGE plpgsql;

    CREATE OR REPLACE FUNCTION Z_99_Deprecated.GetStandardTxtBemerkungsV(ident VARCHAR, lang VARCHAR DEFAULT prodat_languages.curr_lang(), getrtf BOOLEAN DEFAULT TRUE) RETURNS TEXT AS $$
      SELECT belarzu__zu_tit__gettxt($1, $2);
      $$LANGUAGE sql;

CREATE OR REPLACE FUNCTION belarzu__zu_tit__gettxtrtf(
      IN  ident   VARCHAR,
      IN  lang    VARCHAR DEFAULT prodat_languages.curr_lang(),
      OUT txt     TEXT,
      OUT txtrtf  TEXT
      )
    AS $$
    BEGIN
      SELECT zu_txt1, zu_txt1_rtf
        INTO txt, txtrtf
        FROM belarzu
       WHERE zu_tit = ident
         AND zu_spr_key = lang;

      IF     NOT found
         AND     lang IS DISTINCT FROM curr_lang()
      THEN--in abweichender Sprache nix gefunden, dann Standardsprache (Default)
             SELECT deflang.txt, deflang.txtrtf
               INTO txt, txtrtf
               FROM belarzu__zu_tit__gettxtrtf(ident) AS deflang
             ;
      END IF;

      RETURN;
    END $$ LANGUAGE plpgsql;

    CREATE OR REPLACE FUNCTION Z_99_Deprecated.GetStandardTxtBemerkungsV_TXTRTF(ident VARCHAR, lang VARCHAR DEFAULT prodat_languages.curr_lang(), OUT txt TEXT, OUT txtrtf TEXT) AS $$
      SELECT belarzu__zu_tit__gettxtrtf($1, $2);
      $$LANGUAGE sql;

-- siehe IsDevelopSystem in ProdatCommon.pas
CREATE OR REPLACE FUNCTION IsDevelopSystem() RETURNS BOOLEAN AS $$
    BEGIN
      --RETURN upper(current_database()) = 'DEVELOP' OR upper(TSystem.Settings__Get('KUNDE')) IN ('%', 'DEVELOP');
      RETURN TSystem.Settings__GetBool('IsDevelopSystem');
    END $$ LANGUAGE plpgsql STABLE;

/**/

 CREATE OR REPLACE FUNCTION cdssync() RETURNS TRIGGER AS $$
    DECLARE id INTEGER;
    BEGIN
     IF (TG_OP = 'DELETE') THEN
            id:=old.dbrid;
     ELSE
            id:=new.dbrid;
     END IF;

     /*INSERT INTO cdssync (sy_table, sy_action, sy_dbrid) VALUES (TG_RELNAME, TG_OP, id);*/

     RETURN new;
    END$$LANGUAGE plpgsql IMMUTABLE;


 /*Modified für alle Tabellen setzen!!!!!*/
CREATE OR REPLACE FUNCTION table_modified() RETURNS TRIGGER AS $$
    BEGIN

     IF    (tg_relname = 'settings')                -- Tabelle settings ausschliesen

        OR (current_user = 'syncro')                -- Änderungen von Nutzer syncro ausschließen
        OR (current_user = 'postgres')              -- Änderungen von Nutzer postgres ausschließen

           -- #14092 APPS soll z.B. durch DailyDBFunctions nicht als letzer Änderer stehen, in z.B. bdep dafür schon
        OR ( (current_user = 'APPS')                -- Änderungen von Nutzer APPS ausschließen, es sei denn,

             AND NOT (TG_OP = 'INSERT')             -- Wenn APPS was erstellt (EDI) muss das auch entsprechend Insert gesetzt sein

             -- TG_OP = UPDATE
             -- der APPS ändert an der Tabellen, diese Änderungs-Daten wollen wir haben (#20206)
             AND NOT (TG_TABLE_NAME IN ('bdep', 'bdep__terminal_datafox__errorlog'))
            )

        OR (TG_OP = 'INSERT' AND new.insert_by = 'docker') -- CI: bewußt ein insert_date setzen

     THEN
        RETURN new;
     END IF;

     --
     IF tg_op = 'UPDATE' THEN

        -- keine Änderung
        IF new.* IS NOT DISTINCT FROM old.* THEN
           RETURN new;
        END IF;

        -- update überschreibt insert_* oder modified_*
        -- HINWEIS DS: public. wegen FDW https://redmine.prodat-sql.de/issues/16893#note-32

         IF ( NOT public.modifieddisabled() ) THEN

              IF ( new.modified_by IS NOT DISTINCT FROM old.modified_by ) THEN
                new.modified_by    := current_user;
              END IF;

              IF ( new.modified_date IS NOT DISTINCT FROM old.modified_date ) THEN
                new.modified_date  := public.currenttime();
              END IF;

         END IF;

     ELSE --  INSERT
         -- wenn nicht explizit angegeben, verwenden wir die session daten
         /*
          IF ( new.insert_by IS NULL ) THEN
            new.insert_by    := current_user;
          END IF;

          IF ( new.insert_date IS NULL ) THEN
            new.insert_date := current_date;
          END IF;

          IF ( new.modified_by IS NULL ) THEN
            new.modified_by    := current_user;
          END IF;

          IF ( new.modified_date IS NULL ) THEN
            new.modified_date  := public.currenttime();
          END IF;
         */

         -- insert fall currenttime
         IF NOT public.modifieddisabled() THEN
             IF    ( -- beim Kopieren wird Insert/Mofified mitgenommen durch die Kopie. Aber wir sind im INSERT und der Datensatz wird neu erstellt. Somit ist dies die Erkennung, das hier ein neuer Datensatz erstellt wird!
                     ( new.insert_date IS null OR new.insert_date < current_date )
                    )
             THEN -- falls man explizit was angeben will beim Einfügen, kann der Automatismus vorher deaktiviert werden!
                 -- Bei Kopieren von Daten ist es wichtig, das die Vorgaben immer überschrieben werden!
                 new.insert_by      := current_user;
                 new.insert_date    := current_date;
                 new.modified_by    := current_user;
                 new.modified_date  := public.currenttime();
             END IF;
         END IF;
     END IF;

     RETURN new;

    END $$ LANGUAGE plpgsql;


 /*Delete für alle Tabellen setzen!!!!!*/
 CREATE OR REPLACE FUNCTION table_delete() RETURNS TRIGGER AS $$
    DECLARE dokident VARCHAR;
    BEGIN
      -- Schlagworte löschen, welche direkt am Datensatz hängen (INDEX nur auf DBRID)
      --DELETE FROM recnokeyword WHERE r_dbrid = old.dbrid /*AND r_tablename = TG_RELNAME*/;

      -- HINWEIS DS: public. wegen FDW https://redmine.prodat-sql.de/issues/16893#note-32

      UPDATE public.recnokeyword SET r_dbrid = r_dbrid || '_DELETED' WHERE r_dbrid = old.dbrid /*AND r_tablename = TG_RELNAME*/;

      -- Dokumentverlinkungen und meine Dokumente löschen
      -- Grund: Datensatz wird gelöscht und ein gleichnamiger Datensatz wird neu erstellt -> alte angehängte Dokumente sind sonst wieder da
      -- https://redmine.prodat-sql.de/issues/8412    https://redmine.prodat-sql.de/issues/8167
      BEGIN
        -- Dokumentverlinkungen löschen (picndokulink ... recnokeyword siehe unten)
        DELETE FROM public.picndokulink WHERE pdl_dbrid = old.dbrid /*AND pdl_tablename = TG_RELNAME*/;
        --UPDATE picndokulink SET pdl_dbrid = pdl_dbrid || '_DELETED' WHERE pdl_dbrid = old.dbrid /*AND pdl_tablename = TG_RELNAME*/;

        -- Dokumente ausblenden, wenn sie an mir hingen (Verschlagwortung bleibt ebenfalls erhalten, siehe nachfolgendes DELETE FROM recnokeyword)
        UPDATE public.picndoku SET pd_deletable = True WHERE pd_dbrid = old.dbrid AND NOT pd_deletable;

        -- Dokumente die ausgecheckt sind wieder einchecken (das auschecken entfernen)
        UPDATE public.picndoku_revision
        SET pdr_blocked_pd_id = null, pdr_blocked_date = null, pdr_blocked_by = null
        WHERE pdr_blocked_pd_id IN (SELECT pd_id FROM public.picndoku WHERE pd_dbrid = old.dbrid);
        /*
        -- Dokumentverlinkung aus Schlagworten löschen (siehe TDokument.Create SqlWhereKW)
        SELECT dt_dokident INTO dokident FROM dokutypes WHERE dt_linkto = TG_RELNAME AND dt_dokident IS NOT NULL LIMIT 1;  -- LIMIT, da es mehrere Dokutypen geben kann, wo das definiert wurde
        IF (dokident IS NOT NULL) AND exists(SELECT true FROM information_schema.columns
              WHERE table_schema = 'public' AND table_name = TG_RELNAME AND column_name = dokident) THEN
          --EXECUTE 'DELETE FROM recnokeyword WHERE ...; ';
          EXECUTE 'UPDATE recnokeyword SET r_dbrid = r.r_dbrid || ''_DELETED'' '
               || 'FROM recnokeyword AS r '
               -- nur löschen, wenn es auch "wirklich" eine Dokumentverlinkung ist und nicht nur zufällig so aussieht (manuell angelegtes Schlagwort)
               || 'JOIN picndoku ON picndoku.dbrid = r.r_dbrid '
               -- nicht löschen, wenn das Dokument direkt an mir hing (Verlinkung bleibt bestehen, aber pd_deletable=True wurde gesetzt)
               || '  AND picndoku.pd_dbrid <> $1 '
               -- der Zugriff auf old.[dokident] ist leider nicht möglich, darum der SELECT/JOIN über die entsprechende Tabelle (DBRID > IdentField)
               || 'JOIN ' || TG_RELNAME || ' ON ' || TG_RELNAME || '.dbrid = $1 '
               || '  AND ' || dokident || ' = r.r_descr '
               -- wegen dem FROM : in den JOINs gibt es keinen Lesezugriff auf die Felder der Update-Table ... geht nur im WHERE
               || 'WHERE recnokeyword.dbrid = r.dbrid ' USING old.dbrid;
        END IF;
        */
      END;

      RETURN old;
    END $$ LANGUAGE plpgsql;

/*
Funktion, damit die ABK-Struktur als zugeordnete untergeordnete Organisations-struktur gelöscht wird, wenn das Hauptelement gelöscht wird
*/
 CREATE OR REPLACE FUNCTION table_delete_abkstru() RETURNS TRIGGER AS $$
    BEGIN
     DELETE FROM abk WHERE ab_dbrid=old.dbrid;
     RETURN old;
    END $$ LANGUAGE plpgsql;

/*Funktion die zu einem Hauptmenupunkt zurückgibt, ob die Parent alle Sichtbar sind*/

DROP FUNCTION IF EXISTS TSystem.role_sys_mandant_is;
CREATE OR REPLACE FUNCTION TSystem.role_sys_mandant_is( _rolename varchar) RETURNS BOOL AS $$
    DECLARE _mandant_user_group varchar = 'SYS.MANDANT.' || current_database();
            _hasparents int[];
    BEGIN
      _rolename := replace(_rolename, '~', '');
    
      -- Es gibt meinen Mandanten NICHT. Somit ist alles zugänglich
      IF NOT EXISTS (SELECT true FROM pg_group WHERE groname = _mandant_user_group) THEN
          RETURN true;
      -- ES GIBT MEINEN MANDANTEN
      ELSIF _rolename LIKE 'SYS.MANDANT.%' AND _rolename <> _mandant_user_group THEN
          RETURN false;
      END IF;
      
      -- Rolle ist definitv UNSEREM Mandanten zugewiesen
      IF TSystem.roles__user__group__is_in(_rolename, _mandant_user_group) THEN
          RETURN true;
      END IF;
      
      -- Rolle ist ANDEREM Mandanten zugewiesen
      IF EXISTS(SELECT true FROM pg_group JOIN pg_roles ON pg_roles.oid = ANY(grolist) WHERE rolname = _rolename AND groname LIKE 'SYS.MANDANT%') THEN
          RETURN false;
      END IF;
      
      -- Rolle ist niemandem zugewiesen => für alle
      SELECT array_agg(parent.grosysid) INTO _hasparents
        FROM pg_group me JOIN pg_group parent ON me.grosysid = ANY(parent.grolist)
       WHERE parent.groname LIKE 'SYS.MANDANT.%'
       AND me.groname = _rolename;
      
      IF array_length(_hasparents, 1) IS null THEN
        RETURN null;
      END IF;
      --
      
      RETURN false;
    END $$ LANGUAGE plpgsql STABLE;

/*Prüft ob ein bestimmter Benutzer (llminr) Zugriff auf Hauptmenüpunkt readonly (mmid) hat */
CREATE OR REPLACE FUNCTION checkreadonlyaccess(mmid integer, username VARCHAR) RETURNS BOOL AS $$
    DECLARE r RECORD;
            Acc Bool;
            Result Bool;
            mmparent INTEGER;
    BEGIN
     Result:=False;

     --wir prüfen ob genau der Menupunkt auf ReadOnly steht. Untergeordnetes muß dazu nicht geprüft werden da der menupunkt exakt geprüft wird
     --es kann aber sein das durch 2 benutzergruppen einmal readonly ist, und einmal nicht. daher müssen wir noch explicitaccess prüfen
     SELECT true INTO Acc
       FROM mainmenurights
      WHERE mmr_mm_id = mmid
        AND mmr_readonly
        AND mmr_username IN (SELECT * FROM TSystem.roles__user__groups__get(username)) AND NOT (SELECT CheckExplizitAccess(mmr_mm_id, true));
     --
     If COALESCE(Acc, False) THEN
            Result:=True;
            RETURN True;
     END If;

     --wenn die übergeordneten Recht nicht geerbt sind, brauchen wir auch nicht weiter zu suchen
     IF NOT mm_inheritedrights FROM mainmenu WHERE mm_id = mmid THEN
        RETURN false;--Übergeordnete Berechtigungen nicht erben
     END IF;
     --
     SELECT mm_parent INTO mmparent FROM mainmenu WHERE mm_id=mmid;

     --rückwärts prüfen ob zB Nur Lese Rechte vererbt werden vom Obergeordneten Menupunkt
     FOR r IN SELECT mm_id FROM mainmenu WHERE mm_id = mmparent LOOP
            --
            SELECT true INTO Acc
              FROM mainmenurights
             WHERE mmr_mm_id = r.mm_id
               AND mmr_readonly
               AND mmr_username IN (SELECT * FROM TSystem.roles__user__groups__get(username)) AND NOT (SELECT CheckExplizitAccess(mmr_mm_id, true));

            IF coalesce(Acc, False) THEN
               Result:=True;
               RETURN True;
            END IF;
            --
            Result:=checkreadonlyaccess(r.mm_id,username);
            --
            IF Result THEN
                    RETURN Result;
            END IF;
     END LOOP;
     RETURN Result;
    END $$ LANGUAGE plpgsql STABLE;

--

CREATE OR REPLACE FUNCTION checkparentaccess(mmid INTEGER, username VARCHAR) RETURNS BOOL AS $$
    DECLARE r RECORD;
            Acc Bool;
            Result Bool;
            mmparent INTEGER;
    BEGIN
     IF NOT mm_inheritedrights FROM mainmenu WHERE mm_id=mmid THEN
            RETURN false;--Übergeordnete Berechtigungen nicht erben
     END IF;
     --
     Result:=False;
     SELECT mmr_allow INTO Acc
       FROM mainmenurights
      WHERE mmr_mm_id = mmid
        AND mmr_username IN (SELECT * FROM TSystem.roles__user__groups__get(username));
     --
     If Acc THEN
            Result:=True;
            RETURN True;
     END IF;
     IF NOT Acc THEN
            Result:=False;
            RETURN False;
     END IF;
     --
     SELECT mm_parent INTO mmparent FROM mainmenu WHERE mm_id=mmid;
     --rückwärts prüfen ob zB Nur Lese Rechte vererbt werden vom Obergeordneten Menupunkt
     FOR r IN SELECT mm_id FROM mainmenu WHERE mm_id=mmparent LOOP
            SELECT true INTO Acc
              FROM mainmenurights
             WHERE mmr_mm_id = r.mm_id
               AND mmr_allow
               AND mmr_username IN (SELECT * FROM TSystem.roles__user__groups__get(username));

            If coalesce(Acc, False) THEN
                    Result := True;
                    RETURN True;
            END If;
            Result := checkparentaccess(r.mm_id,username);
            If Result THEN
                    RETURN Result;
            END IF;
     END LOOP;
     RETURN Result;
    END $$ LANGUAGE plpgsql STABLE;


/*Prüft ob ein eingeloggter Benutzer Zugriff auf Hauptmenüpunkt (mmid) hat */
CREATE OR REPLACE FUNCTION CheckExplizitAccess(mmid INTEGER) RETURNS BOOL AS $$
    BEGIN
     RETURN checkexplizitaccess(mmid, current_user::VARCHAR);
    END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION CheckExplizitAccess(mmid INTEGER, checkexactmmidonly BOOL) RETURNS BOOL AS $$
    BEGIN
     RETURN checkexplizitaccess(mmid, current_user::VARCHAR, checkexactmmidonly);
    END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION CheckExplizitAccess(mmid INTEGER, username VARCHAR) RETURNS BOOL AS $$
    BEGIN
     RETURN checkexplizitaccess(mmid, username, false);
    END $$ LANGUAGE plpgsql;


/*Prüft ob ein bestimmter Benutzer (llminr) Zugriff auf Hauptmenüpunkt (mmid) hat */
CREATE OR REPLACE FUNCTION CheckExplizitAccess(mmid integer, username VARCHAR, checkexactmmidonly BOOL) RETURNS BOOL AS $$
    DECLARE r RECORD;
            Acc Bool;
            Result Bool;
    BEGIN
     Result := False;
     -- Readonly wird mit Or CheckReadOnlyAccess verknüpft. Diese funktion gibt nur zurück wenn jemand aussergewöhnliches Schreibrecht hat
     -- ausserdem muß eine Freigabe möglich sein, obwohl von oben ein ReadOnly kommt
     SELECT true INTO Acc
       FROM mainmenurights
      WHERE mmr_mm_id = mmid
        AND mmr_allow
        AND NOT mmr_readonly
        AND mmr_username IN (SELECT * FROM TSystem.roles__user__groups__get(username));
     --
     If coalesce(Acc, False) THEN
        RETURN True;
     END If;
     --
     IF checkexactmmidonly THEN--exakte prüfung auf menupunkt. unterschied: wenn menustruktur geprüft wird, muß geschaut werden ob ein untermenupunkt erlaubt ist, um dann auch den eigentlich nicht erlaubten obermenupunkt darzustellen
        RETURN false;--dieser menupunkt hat kein explizites recht, daher geben wir direkt false zurück und die untermenupunkte interessieren uns nicht
     END IF;
     --
     --vorwärts prüfen ob der hauptmenupunkt erhalten bleiben muß, da ein untermenupunkt nun doch da sein soll
     FOR r IN SELECT mm_id FROM mainmenu WHERE mm_parent=mmid LOOP
            --prüfen ob drunter der menupunkt explizit erlaubt ist, dabei spielt readonly natürlich keine rolle
            SELECT true INTO Acc
              FROM mainmenurights
             WHERE mmr_mm_id = r.mm_id
               AND mmr_allow
               AND mmr_username IN (SELECT * FROM TSystem.roles__user__groups__get(username));

            If coalesce(Acc, False) THEN
                    Result := True;
                    RETURN True;
            END If;

            Result := CheckExplizitAccess(r.mm_id,username);

            If Result THEN
               RETURN Result;
            END IF;
     END LOOP;
     RETURN Result;
    END $$ LANGUAGE plpgsql STABLE;



CREATE OR REPLACE FUNCTION mainmenu_access(mmparent INTEGER, mmid INTEGER, CheckForward BOOL) RETURNS BOOLEAN AS $$
    DECLARE result BOOLEAN;
            newmmparent INTEGER;
            hasrights Boolean;
            r RECORD;
    BEGIN
     If CheckForward AND CheckExplizitAccess(mmid) THEN
        RETURN true;
     END IF;
     --
     HasRights:=NULL;
     Result:=True;
     --wenn es einen Parent gibt, dann diesen jetzt prüfen
     FOR r IN SELECT mmr_username FROM mainmenurights WHERE mmr_mm_id = mmid AND mmr_allow AND NOT mmr_readonly LOOP --wir haben exklusiven Zugriff
         IF HasRights IS NULL THEN
            HasRights := False OR (CheckParentAccess(mmid, CAST(current_user AS VARCHAR)));
         END IF;
         --es gibt also Berechtigungen (exklusiver Zugriff) auf diesen Punkt
         IF r.mmr_username IN (SELECT * FROM TSystem.roles__user__groups__get(CAST(current_user AS VARCHAR))) THEN
            HasRights:=True;
         END IF;
     END LOOP;
     IF NOT HasRights THEN
        --es gibt Exklusiven Zugriff und wir sind nicht dabei!
        Result := false;
     ELSIF HasRights THEN
        Result := true;
     END IF;

     --Exclusiver Zugriff getestet
     --exklusives verbieten
     IF EXISTS(SELECT true FROM mainmenurights
                WHERE mmr_mm_id = mmid
                  AND NOT mmr_allow
                  AND NOT mmr_readonly
                  AND mmr_username IN (SELECT * FROM TSystem.roles__user__groups__get(CAST(current_user AS VARCHAR)))
               )
     THEN
        Result := false;
     END IF;
     --
     if Result AND (mmparent IS NOT NULL) THEN--bisher haben wir zugriffsrechte, nun prüfen wir mal die übergeordneten
            SELECT mm_parent INTO newmmparent FROM mainmenu WHERE mm_id=mmparent;
            Result := mainmenu_access(newmmparent, mmparent, False) OR (CheckParentAccess(mmid, CAST(current_user AS VARCHAR)));--ansonsten eine Ebene höher gehen
     END IF;
     --Zugriff verboten? Dann prüfen wir nochmal die untergeordneten ob Explizit Zugriff gewährt
     RETURN Result;
    END $$ LANGUAGE plpgsql STABLE;
--

--
CREATE OR REPLACE FUNCTION aeoeue_upper(in_string VARCHAR) RETURNS VARCHAR AS $$
  SELECT translate(UPPER(in_string), 'ÄÖÜ', 'AOU');
  $$ LANGUAGE sql IMMUTABLE;
--

--
 CREATE OR REPLACE FUNCTION max(p1 INTEGER, p2 INTEGER) RETURNS INTEGER AS $$
  SELECT greatest(p1, p2);
  $$ LANGUAGE sql IMMUTABLE;

 CREATE OR REPLACE FUNCTION max(p1 NUMERIC, p2 NUMERIC) RETURNS NUMERIC AS $$
  SELECT greatest(p1, p2);
  $$ LANGUAGE sql IMMUTABLE;

 CREATE OR REPLACE FUNCTION max(p1 VARCHAR, p2 VARCHAR) RETURNS VARCHAR AS $$
  SELECT greatest(p1, p2);
  $$ LANGUAGE sql IMMUTABLE;
--

/*STRING FUNKTIONEN*/

CREATE OR REPLACE FUNCTION StrGetPart(Str VARCHAR, SplitPart VARCHAR, ReturnAllIfNotFound BOOLEAN DEFAULT TRUE) RETURNS VARCHAR AS $$
 DECLARE _pos INTEGER;
 BEGIN
 _pos:=StrPos(Str, SplitPart);
 If _pos=0 AND ReturnAllIfNotFound THEN
        RETURN Str;
 ELSE
        RETURN SubStr(Str, 1, _pos-1);
 END IF;
 END $$ LANGUAGE plpgsql STABLE;

CREATE FUNCTION instr(VARCHAR,VARCHAR) RETURNS INTEGER AS $$
 DECLARE
        pos integer;
 BEGIN
 pos:= instr($1,$2,1);
 RETURN pos;
 END $$ LANGUAGE plpgsql;


CREATE FUNCTION instr(VARCHAR,VARCHAR,INTEGER) RETURNS INTEGER AS $$
 DECLARE
        string ALIAS FOR $1;
        string_to_search ALIAS FOR $2;
        beg_index ALIAS FOR $3;
        pos integer NOT NULL DEFAULT 0;
        temp_str VARCHAR;
        beg INTEGER;
        length INTEGER;
        ss_length INTEGER;
 BEGIN
  IF beg_index > 0 THEN
        temp_str := substring(string FROM beg_index);
        pos := position(string_to_search IN temp_str);
        IF pos = 0 THEN
                RETURN 0;
        ELSE
                RETURN pos + beg_index - 1;
        END IF;
  ELSE
        ss_length := char_length(string_to_search);
        length := char_length(string);
        beg := length + beg_index - ss_length + 2;
        WHILE beg > 0 LOOP
                temp_str := substring(string FROM beg FOR ss_length);
                pos := position(string_to_search IN temp_str);
                IF pos > 0 THEN
                        RETURN beg;
                END IF;
                beg := beg - 1;
        END LOOP;
  RETURN 0;
  END IF;
 END $$ LANGUAGE plpgsql;


CREATE FUNCTION instr(VARCHAR,VARCHAR,INTEGER,INTEGER) RETURNS INTEGER AS $$
 DECLARE
        string ALIAS FOR $1;

        string_to_search ALIAS FOR $2;
        beg_index ALIAS FOR $3;
        occur_index ALIAS FOR $4;
        pos integer NOT NULL DEFAULT 0;
        occur_number INTEGER NOT NULL DEFAULT 0;
        temp_str VARCHAR;
        beg INTEGER;
        i INTEGER;
        length INTEGER;
        ss_length INTEGER;
  BEGIN
   IF beg_index > 0 THEN
        beg := beg_index;
        temp_str := substring(string FROM beg_index);
        FOR i IN 1..occur_index LOOP
                pos := position(string_to_search IN temp_str);
                IF i = 1 THEN
                        beg := beg + pos - 1;
                ELSE
                        beg := beg + pos;
                END IF;
                temp_str := substring(string FROM beg + 1);
        END LOOP;
        IF pos = 0 THEN
                RETURN 0;
        ELSE
                RETURN beg;
        END IF;
  ELSE
        ss_length := char_length(string_to_search);
        length := char_length(string);
        beg := length + beg_index - ss_length + 2;
        WHILE beg > 0 LOOP
                temp_str := substring(string FROM beg FOR ss_length);
                pos := position(string_to_search IN temp_str);
                IF pos > 0 THEN
                        occur_number := occur_number + 1;
                        IF occur_number = occur_index THEN
                                RETURN beg;
                        END IF;
                END IF;
                beg := beg - 1;
        END LOOP;
        RETURN 0;
  END IF;
 END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION addsum(IN id INTEGER, IN sumtoadd NUMERIC, OUT summe NUMERIC) RETURNS NUMERIC AS $$
 BEGIN
  summe:=TSystem.Settings__GetNumeric('_tmp'||id)+COALESCE(sumtoadd,0);
  PERFORM TSystem.Settings__SetText('_tmp'||id, summe);
  RETURN;
 END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION Do1If0(Input NUMERIC) RETURNS NUMERIC AS $$ --Division durch 0 vermeiden
 BEGIN
  IF Input=0 THEN
        RETURN 1;
  ELSE
        RETURN Input;
  END IF;
 END$$LANGUAGE plpgsql IMMUTABLE;

CREATE OR REPLACE FUNCTION DoNULLIf0(Input NUMERIC) RETURNS NUMERIC AS $$ --Für LEAST 0 auf NULL
 BEGIN
  IF Input=0 THEN
        RETURN NULL;
  ELSE
        RETURN Input;
  END IF;
 END$$LANGUAGE plpgsql IMMUTABLE;

/* => abk_functions: (Reihenfolge Typ ABK)
CREATE OR REPLACE FUNCTION tableident_allfields(
  IN  _abk abk,
*/


--tableident-funktionen für ABK und DMS
--tableident-funktionen für ABK und DMS
CREATE OR REPLACE FUNCTION tableident_allfields(
  IN  _tablename      character varying,
  IN  _dbrid          character varying,
  OUT ident           character varying,
  OUT aknr            character varying,
  OUT annr            character varying,
  OUT keyvalue        character varying,
  OUT txt             text
  )
  RETURNS record
  AS $$
  BEGIN
     IF _tablename = 'anl' THEN
          SELECT an_nr, an_ak_nr, concat_ws( ' | ', an_nr, an_bez ), an_nr
            INTO annr, aknr, ident, keyvalue
            FROM anl
           WHERE anl.dbrid = _dbrid;

      ELSIF _tablename = 'auftgtxt' THEN

          SELECT at_astat || '.' || at_nr
            INTO ident
            FROM auftgtxt
           WHERE auftgtxt.dbrid = _dbrid;

      ELSIF _tablename = 'ldsdok' THEN

          SELECT ld_an_nr, ld_aknr, twawi.ldsdok_GenConcatNr( ldsdok ), ld_auftg
            INTO annr, aknr, ident, keyvalue
            FROM ldsdok
           --hier ab_keyvalue direkt, da in recnocommentkategorie bereits ldsdoktxt enthalten ist für Bestellnummer
           WHERE dbrid = _dbrid;

      ELSIF _tablename = 'kundanfrage' THEN

          SELECT kanf_an_nr, kanf_ak_nr, kanf_nr
            INTO annr, aknr, keyvalue
            FROM kundanfrage
           WHERE dbrid = _dbrid;

      -- kundanfrage__a_iu__annr
      ELSIF _tablename = 'kundservicepos' THEN

          SELECT kanf_an_nr, kanf_ak_nr, concat_ws( ' | ', kanf_an_nr, kanfse_pos, ' -> ', kanfse_sfall )
            INTO annr, aknr, ident
            FROM kundservicepos
            JOIN kundanfrage ON kanfse_kanf_nr = kanf_nr AND kanf_isService
           WHERE kundservicepos.dbrid = _dbrid;

      -- kundanfrage__a_iu__annr !! Seit #10625 ist ab_keyvalue = q_nr.
      -- Vorher war das unter Umständen der Nacharbeits-Fertigungsauftrag. Den gibt es aber nicht immer.
      ELSIF _tablename = 'qab' THEN

          SELECT
              kanf_an_nr,
              coalesce( kanf_ak_nr, q_ak_nr ),
              concat_ws( ' | ', q_nr, 'SA-' || kanfse_kanf_nr || ' : ' || kanfse_pos || ' -> ' || kanfse_sfall ),
              q_nr
            INTO annr, aknr, ident, keyvalue
            FROM qab
            LEFT JOIN kundservicepos ON q_kanfse_id = kanfse_id
            LEFT JOIN kundanfrage ON kanfse_kanf_nr = kanf_nr
           WHERE qab.dbrid = _dbrid;

      --Änderungsmanagement
      ELSIF _tablename = 'beleg_k__artchange' THEN

          SELECT k_nummer || ifthen( k_titel IS NOT null, ' | ' || k_titel, '' ), k_nummer
            INTO ident, keyvalue
            FROM tartikel.beleg_k__artchange
           WHERE dbrid = _dbrid;

      ELSIF _tablename = 'vertrag' THEN

          SELECT
              vtr_an_nr,
              concat_ws(
                  ' | ',
                 vtr_an_nr,
                 concat_ws( E'\n', vtr_gegenstand, vtr_bez, adressename( vtr_krz ) )
              ),
              vtr_nr
            INTO annr, ident, keyvalue
            FROM vertrag
           WHERE dbrid = _dbrid;

          -- Verwendung aktuell unklar: DS 2018-04-20
          txt := ident;
      END IF;

    RETURN;

  END $$ LANGUAGE plpgsql STABLE STRICT PARALLEL SAFE;


  --gibt nur Kurzzeichen zu einem Tablename zurück. zB Vertrag='VT', Qab='Q', ...
  --_dbrid nur für ausnahmefälle interessant (zB bei QAB um herauszufinden, ob ServiceQAB oder richtiger QAB
CREATE OR REPLACE FUNCTION public.tableident_tablename_short(
    IN _tablename character varying,
    IN _dbrid character varying DEFAULT NULL::character varying
    )
    RETURNS character varying
    AS $$
    BEGIN
      IF _tablename='anl' THEN
        RETURN 'PJ';
      END IF;
      IF _tablename='art' THEN
        RETURN 'ART';
      END IF;
      IF _tablename='auftgtxt' THEN
        RETURN 'AUFTG';
      END IF;
      IF _tablename='ldsdoktxt' THEN
        RETURN 'BE';
      END IF;
      IF _tablename='ldsdok' THEN
        RETURN 'PA';
      END IF;
      IF _tablename='kundanfrage' THEN
        RETURN 'KA';
      END IF;
      IF _tablename='kundservicepos' THEN
        RETURN 'SA';
      END IF;
      IF _tablename='qab' THEN
        IF q_isService FROM qab WHERE dbrid=_dbrid THEN
          RETURN 'SV';
        ELSE
          RETURN 'QAB';
        END IF;
      END IF;
      IF _tablename='vertrag' THEN
        RETURN 'VT';
      END IF;
      RETURN '?'||_tablename; --kein Kurzzeichen für Tabellenname vorhanden
    END $$ LANGUAGE plpgsql STABLE; --kein STRICT! da NULL bei keiner dbrid!


  --gibt den IDENT einer Tabelle zurück, mit oder ohne Zusatzinfos
  CREATE OR REPLACE FUNCTION tableident(_tablename VARCHAR, _dbrid VARCHAR, with_description BOOLEAN DEFAULT true) RETURNS VARCHAR AS $$
    DECLARE result VARCHAR;
    BEGIN
      IF with_description THEN
         result := public.tableident_tablename_short(_tablename, _dbrid);
      END IF;
      RETURN concat_ws('.', result, (SELECT ident FROM public.tableident_allfields(_tablename, _dbrid)));
    END $$ LANGUAGE plpgsql STABLE STRICT;

  /*SELECT TSystem.Create_FComment(
      'tableident_adressbezug_kunde'
     ,'Für eine (freie) ABK Struktur den Adressbezug (Kunde) finden.',
     ,'Adressskürzel (adk)'
     ,ARRAY['_tablename, _dbrid']
     ,ARRAY['ab_tablename, ab_dbrid']
     ,ARRAY['Projektverwaltung','ABK', 'ADK', 'Adressbezug']
     ,''
     ,'QAB => Kunde, normale ABK => Kunde, ServiceVorfall => ServiceAnfrage.Kunde'
     );*/


  CREATE OR REPLACE FUNCTION tableident_adressbezug_kunde(_tablename VARCHAR, _dbrid VARCHAR DEFAULT NULL) RETURNS VARCHAR AS $$
    BEGIN
     IF _tablename='kundservicepos' THEN
            RETURN kanf_ad_krz FROM kundservicepos JOIN kundanfrage ON kanf_nr=kanfse_kanf_nr WHERE _dbrid=kundservicepos.dbrid;
     END IF;
     IF _tablename='qab' THEN
            IF q_isService FROM qab WHERE dbrid=_dbrid THEN
                    RETURN tableident_adressbezug_kunde('kundservicepos', kundservicepos.dbrid) FROM qab JOIN kundservicepos ON q_kanfse_id=kanfse_id WHERE qab.dbrid=_dbrid;--Kunde, von dem der ServiceVorfall ausgelöst wurde
            ELSE
                    RETURN ag_lkn FROM qab JOIN lifsch ON q_l_nr=l_nr JOIN auftg ON ag_id=l_ag_id WHERE qab.dbrid=_dbrid;
            END IF;
     END IF;
     IF _tablename='anl' THEN
            RETURN an_kund FROM anl WHERE anl.dbrid=_dbrid;
     END IF;
     IF _tablename='kundanfrage' THEN
            RETURN kanf_ad_krz FROM kundanfrage WHERE _dbrid=kundanfrage.dbrid;
     END IF;
     IF _tablename='vertrag' THEN
            RETURN vtr_krz FROM vertrag WHERE vertrag.dbrid=_dbrid;
     END IF;
     RETURN '?'||_tablename||'-';--kein Kurzzeichen für Tabellenname vorhanden
    END $$ LANGUAGE plpgsql STABLE STRICT;

--http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Nutzung_der_DB-Callbacks_(pg_notifiy)

    -- Zentrale Notify-Sende-Funktion (Pascal-Äquivalent: TCimNotify.MainSendFunction)
    -- Username="_allusers_" um an ALLE zu senden
    CREATE OR REPLACE FUNCTION PRODAT_COMM_FUNKTION(IN MessageAction VARCHAR, IN Message VARCHAR, IN Username VARCHAR DEFAULT tsystem.current_user_ll_db_usename(true)) RETURNS VOID AS $$
    DECLARE
      stack TEXT;
      caller TEXT;
      spos INTEGER;
    BEGIN
      Username := trim(Username);
      IF (Username = '') OR (Username IS NULL) THEN
        Username := lower(current_user);
      ELSE
        Username := lower(Username);
      END IF;
      -- caller function
      GET DIAGNOSTICS stack = PG_CONTEXT;  -- mehrere Zeilen mit "PL/pgSQL function outer_func() line 3 at ..."
      spos   := 1;
      caller := TSystem.SL_GetLine(stack, spos);
      WHILE caller IS NOT NULL AND (caller !~ '^PL/pgSQL function' OR substring(split_part(caller, ' ', 3) from '^[^(]*')
          ~ '^(prodat_comm_funktion|prodat_message|prodat_message_yes_no|prodat_error|prodat_text|prodat_hint)$') LOOP
        spos   := spos + 1;
        caller := TSystem.SL_GetLine(stack, spos);
      END LOOP;
      caller := trim(substring(caller from length('PL/pgSQL function') + 1));  -- zum Testen alles ausgeben -> caller := stack;
      -- senden
      Message := '"Action=' || replace(trim(COALESCE(MessageAction, 'NULL')), '"', '""') || '";' || trim(COALESCE(Message, 'NULL'))
        || ';CallerFunc="' || replace(COALESCE(caller, ''), '"', '""') || '"';

      RAISE NOTICE 'PRODAT_COMM_FUNKTION(User:%): %', UserName, Message;

      PERFORM pg_notify(Username, Message);
    END $$ LANGUAGE plpgsql STABLE;

    --MessageType=Custom|Information|Warning|Error
    CREATE OR REPLACE FUNCTION PRODAT_MESSAGE(IN Message VARCHAR, IN MessageType VARCHAR, IN Username VARCHAR DEFAULT tsystem.current_user_ll_db_usename(true)) RETURNS VOID AS $$
    BEGIN
      Message := '"Type=' || replace(trim(COALESCE(MessageType, 'NULL')), '"', '""') || '";"Text=' || replace(trim(COALESCE(Message, 'NULL')), '"', '""') || '"';
      PERFORM PRODAT_COMM_FUNKTION('Message', Message, Username);
    END $$ LANGUAGE plpgsql STABLE;

    CREATE OR REPLACE FUNCTION PRODAT_MESSAGE_YES_NO(IN Message VARCHAR, IN SqlYes VARCHAR, IN SqlNo VARCHAR, IN Param ANYELEMENT, IN Username VARCHAR DEFAULT tsystem.current_user_ll_db_usename(true)) RETURNS VOID AS $$
    BEGIN
      Message :=    '"Type=SqlYesNo";"SqlYes=' || replace(trim(COALESCE(SqlYes, '')), '"', '""') || '";'
                 || '"SqlNo='                  || replace(trim(COALESCE(SqlNo, '')), '"', '""') || '";'
                 || '"Text='                   || replace(trim(COALESCE(Message, 'NULL')), '"', '""') || '"'
                 || IFTHEN(Param IS NOT NULL, ';"Param=' || replace(Param, '"', '""') || '"', '');
      PERFORM PRODAT_COMM_FUNKTION('Message', Message, Username);
    END $$ LANGUAGE plpgsql STABLE;

    CREATE OR REPLACE FUNCTION PRODAT_MESSAGE_YES_NO(IN TextNr INTEGER, IN SqlYes VARCHAR, IN SqlNo VARCHAR, IN Param ANYELEMENT, IN Username VARCHAR DEFAULT tsystem.current_user_ll_db_usename(true)) RETURNS VOID AS $$
    BEGIN
      PERFORM PRODAT_MESSAGE_YES_NO(lang_text(TextNr), SqlYes, SqlNo, Param, Username);
    END $$ LANGUAGE plpgsql STABLE;

    CREATE OR REPLACE FUNCTION public.prodat_show_f2( captiontextnr INTEGER, username VARCHAR DEFAULT current_user_ll_db_usename(true)) RETURNS void AS $$
    BEGIN
       --CaptionTextNr für F2-Fenstercaption
       PERFORM PRODAT_MESSAGE(CaptionTextNr::VARCHAR, 'ShowF2', Username);
    END $$ LANGUAGE plpgsql VOLATILE;

    CREATE OR REPLACE FUNCTION PRODAT_ERROR(IN Message VARCHAR, IN Username VARCHAR DEFAULT tsystem.current_user_ll_db_usename(true)) RETURNS VOID AS $$
    BEGIN
      PERFORM PRODAT_MESSAGE(Message, 'Error', Username);
    END $$ LANGUAGE plpgsql STABLE;

    CREATE OR REPLACE FUNCTION PRODAT_TEXT(IN Message VARCHAR, IN Username VARCHAR DEFAULT tsystem.current_user_ll_db_usename(true)) RETURNS VOID AS $$
    BEGIN
      PERFORM PRODAT_MESSAGE(Message, 'Custom', Username);
    END $$ LANGUAGE plpgsql STABLE;

    --Zeigt einen Hint in BalloonHint an, zB "Nummernkreis => Lücke gefunden"
    CREATE OR REPLACE FUNCTION PRODAT_HINT(IN Message VARCHAR, IN Username VARCHAR DEFAULT tsystem.current_user_ll_db_usename(true)) RETURNS VOID AS $$
    BEGIN
      PERFORM PRODAT_MESSAGE(Message, 'ApplicationModulHint', Username);
    END $$ LANGUAGE plpgsql STABLE;

    CREATE OR REPLACE FUNCTION PRODAT_ERROR(IN TextNr INTEGER, IN Username VARCHAR DEFAULT tsystem.current_user_ll_db_usename(true)) RETURNS VOID AS $$
    BEGIN
      PERFORM PRODAT_MESSAGE(lang_text(TextNr), 'Error', Username);
    END $$ LANGUAGE plpgsql STABLE;

    CREATE OR REPLACE FUNCTION PRODAT_TEXT(IN TextNr INTEGER, IN Username VARCHAR DEFAULT tsystem.current_user_ll_db_usename(true)) RETURNS VOID AS $$
    BEGIN
      PERFORM PRODAT_MESSAGE(lang_text(TextNr), 'Custom', Username);
    END $$ LANGUAGE plpgsql STABLE;
--

-- Vereinfachung Abfrage Benutzer in DB-Gruppe
 CREATE OR REPLACE FUNCTION isUserInDBRole(inUser VARCHAR, VARIADIC inGroup VARCHAR[]) RETURNS BOOLEAN AS $$
    BEGIN
      RETURN EXISTS(SELECT TRUE FROM pg_user JOIN pg_group ON usesysid = ANY(grolist) WHERE groname iLIKE ANY(inGroup) AND usename = inUser);
    END $$ LANGUAGE plpgsql STABLE;

-- Versionscheck
 CREATE OR REPLACE FUNCTION assert_VersionEquals(inVersion NUMERIC) RETURNS BOOLEAN AS $$
    DECLARE etext VARCHAR;
    BEGIN
      -- major version hat 2 Stellen, minor version hat 2 Stellen: 9.0.9 = 90009, 9.0.10 = 90010, 9.2.0 = 90200
      -- Alternative wäre: regex, replace, lpad concatenation
      IF ((SELECT setting FROM pg_settings WHERE name='server_version_num')::NUMERIC < inVersion) THEN
            etext:='Server version number does not match requested version'||E'\n\n'
            ||'Server version: '||(SELECT setting FROM pg_settings WHERE name='server_version_num')||E'\n'
            ||'Requested version: '||inVersion;
            RAISE EXCEPTION '%', etext;
      END IF;
      RETURN TRUE;
    END $$ LANGUAGE plpgsql STABLE;
--

-- Umwandlung Strings in DB-Numerics je nach Tausender- bzw. Dezimaltrennzeichen
CREATE OR REPLACE FUNCTION str_to_num(IN inString VARCHAR, IN inSepTh VARCHAR(1), IN inSepDec VARCHAR(1)) RETURNS NUMERIC AS $$
 BEGIN
  IF inSepTh = inSepDec THEN
        RAISE EXCEPTION 'Unable to convert string to numeric. Given thousends separator equals decimal separator.';
  END IF;
  RETURN CAST(REPLACE(REPLACE(inString, inSepTh, ''), inSepDec, '.') AS NUMERIC);
 END $$ LANGUAGE plpgsql STABLE;
--

-- entsprechende Vorgaben nach Land
CREATE OR REPLACE FUNCTION str_to_num__en(IN inString VARCHAR) RETURNS NUMERIC AS $$
 BEGIN
  RETURN str_to_num(inString, ',', '.');
 END $$ LANGUAGE plpgsql STABLE;

CREATE OR REPLACE FUNCTION str_to_num__de(IN inString VARCHAR) RETURNS NUMERIC AS $$
 BEGIN
  RETURN str_to_num(inString, '.', ',');
 END $$ LANGUAGE plpgsql STABLE;

CREATE OR REPLACE FUNCTION str_to_num__ch(IN inString VARCHAR) RETURNS NUMERIC AS $$
 BEGIN
  RETURN str_to_num(inString, '''', ',');
 END $$ LANGUAGE plpgsql STABLE;
--

-- Rundung von Beträgen anhand Rundungsvorschrift (Präzision, Schritte)
  -- z.B. Rappen: 0.05, Cent: 0.01
CREATE OR REPLACE FUNCTION num_round_by_precision_rule( inNum numeric, inRoundRule numeric ) RETURNS numeric AS $$
  DECLARE
    roundFactor numeric;
  BEGIN

    IF COALESCE( inRoundRule, 0 ) <> 0 THEN
        roundFactor := 1 / inRoundRule;
        RETURN round( round( inNum * roundFactor ) / roundFactor, scale( inRoundRule ));
    END IF;

    RETURN inNum;
  END $$ LANGUAGE plpgsql IMMUTABLE;
--


--- #10618
CREATE OR REPLACE FUNCTION twawi.auftg__ag_pos0defini() RETURNS BOOLEAN AS $$
  BEGIN
    RETURN TSystem.Settings__GetBool('wawi__pos0defini');
  END $$ LANGUAGE plpgsql STABLE;

CREATE OR REPLACE FUNCTION twawi.ldsdok__ld_pos0defini() RETURNS BOOLEAN AS $$
  BEGIN
    RETURN TSystem.Settings__GetBool('wawi__pos0defini');
  END $$ LANGUAGE plpgsql STABLE;


-- zwei logische Funktionen, welche nicht als Standard zur Verfügung stehen
CREATE OR REPLACE FUNCTION xor( _b1 boolean, _b2 boolean ) RETURNS boolean AS $$
  -- exklusives ODER

  SELECT ( _b1 AND NOT _b2 ) OR ( NOT _b1 AND _b2 );

$$ LANGUAGE sql IMMUTABLE;


CREATE OR REPLACE FUNCTION xnor( _b1 boolean, _b2 boolean ) RETURNS boolean AS $$
  -- Äquivalenz

  SELECT NOT xor( _b1, _b2 );

$$ LANGUAGE sql IMMUTABLE;


--------- Funktionen zur Umwandlung von Hexstrings in base64 und umgekehrt

CREATE OR REPLACE FUNCTION base64_code_list() RETURNS varchar AS $$

    SELECT 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/' :: varchar;

$$ LANGUAGE sql STRICT IMMUTABLE;


CREATE OR REPLACE FUNCTION hex_to_integer( _hex varchar ) RETURNS integer AS $$
  DECLARE
    _result integer;
  BEGIN

    -- stellt eine Hexadezimalzahl als Dezimalzahl dar
    -- das Gegenstück zur to_hex-Funktion

    EXECUTE 'SELECT x''' || _hex || ''' :: integer' INTO _result;
    RETURN _result;

  END $$ LANGUAGE plpgsql STRICT IMMUTABLE;


CREATE OR REPLACE FUNCTION hex_to_base64( _hex varchar ) RETURNS varchar AS $$
  DECLARE
    _chars varchar;
    _statement varchar;
    _bits bit varying;
    _padding varchar;
    _result varchar;
    _runs integer;
    _i integer;
    _index integer;
  BEGIN

    -- wandelt einen String, der eine Hexadezimalzahl repräsentiert
    -- in einen base64-String um
    -- siehe auch https://de.wikipedia.org/wiki/Base64

    _chars := base64_code_list();

    _statement := 'SELECT x''' || _hex || '''';
    EXECUTE _statement INTO _bits;

    _padding = '';
    WHILE length( _bits ) % 3 <> 0 LOOP
      _bits := _bits || 0::bit(8);
      _padding := _padding || '=';
    END LOOP;

    _result := '';
    _runs := length(_bits) / 6 - length( _padding );
    FOR _i IN 1.._runs LOOP
      _index := _bits::bit(6)::integer;
      _result := _result || substring( _chars, _index+1, 1 );
      _bits := _bits << 6;
    END LOOP;

    _result := _result || _padding;
    RETURN _result;

  END $$ LANGUAGE plpgsql STRICT IMMUTABLE;


CREATE OR REPLACE FUNCTION base64_to_hex( _base64 varchar ) RETURNS varchar AS $$
  DECLARE
    _chars varchar;
    _b64 varchar;
    _resultBits bit varying;
    _result varchar;
    _ch varchar;
    _i integer;
    _num numeric;
  BEGIN

    -- wandelt eine base64-kodierte Hexadezimalzahl
    -- in einen unkodierten String um
    -- siehe auch https://de.wikipedia.org/wiki/Base64

    _b64 := replace( _base64, '=', '') ;
    _chars := base64_code_list();

    _resultBits := 1;
    FOR _i IN 1..length( _b64 ) LOOP
      _ch := substring( _b64, _i, 1 );
      IF _i = 1 THEN
        _resultBits := (position( _ch IN _chars ) - 1)::bit(6);
      ELSE
        _resultBits := _resultBits || (position( _ch IN _chars ) - 1)::bit(6);
      END IF;
    END LOOP;

    _result := '';
    FOR _i IN 1..length( _resultBits ) / 4 LOOP
      _result := _result || upper( to_hex( _resultBits::bit(4)::integer ));
      _resultBits := _resultBits << 4;
    END LOOP;

    IF _base64 LIKE '%==' AND _result LIKE '%0' THEN
      _result := substr( _result, 1, length( _result ) - 1 );
    END IF;

    RETURN _result;

  END $$ LANGUAGE plpgsql STRICT IMMUTABLE;


-- Execution Flags Beginn

    -- Flags zum Steuern des Programflusses (z.B. zeitweise deaktivieren eines Triggers)
    -- Parameter sind die optimalen "Variablen" für diesen Zweck, da sie nur während einer Transaktion existieren können (siehe Parameter "is_local" von set_config()).
    -- Für die Parameter sind die Adminfunktionen set_config() und current_setting() zu verwenden.
    --
    /* Ausführungsflag in aktueller Transaktion setzen (erhöhen). */
    SELECT tsystem.function__drop_by_regex( 'execution_flag__aquire', 'TSystem', _commit => true );
    CREATE OR REPLACE FUNCTION TSystem.execution_flag__aquire(
          _flagname               varchar,             -- Name des Ausführungsflags
          _loglevel               int       DEFAULT TSystem.Log_Get_LogLevel( _user => 'yes' )
      ) RETURNS VOID AS $$

      DECLARE

          _prefix       varchar := format( 'execution_flag__aquire flag %L -', _flagname );

          _fullflagname varchar;
          _flagvalue    integer;

      BEGIN

          _fullflagname := 'myflag.' || _flagname || '_' || pg_backend_pid()::varchar;  -- Parameter müssen zwingend mindestens einen Punkt im Namen haben,
                                                                                        -- ... ansosnten wird folgende Fehlermeldung geworfen:
                                                                                        -- ERROR:  unrecognized configuration parameter "xyz"

          _flagvalue := set_config(
                            /*setting_name  =>*/ _fullflagname
                          , /*new_value     =>*/ ( coalesce( NullIf( current_setting( /*setting_name =>*/ _fullflagname, /*missing_ok =>*/ true ), '' )::integer, 0 ) + 1 )::varchar
                          , /*is_local      =>*/ true
                        );

          -- Debug
          IF _loglevel >= 5 THEN
              RAISE NOTICE '% fullname:%, value:%;', _prefix, _fullflagname, _flagvalue;
          END IF;

          RETURN;

      END $$ LANGUAGE plpgsql;


    /* Ausführungsflag in aktueller Transaktion löschen (reduzieren). */
    SELECT TSystem.function__drop_by_regex( 'execution_flag__release', 'TSystem', _commit => true );
    CREATE OR REPLACE FUNCTION TSystem.execution_flag__release(
          _flagname               varchar,             -- Name des Ausführungsflags
          _loglevel               int       DEFAULT TSystem.Log_Get_LogLevel( _user => 'yes' )
      ) RETURNS VOID AS $$

      DECLARE

          _prefix       varchar := format( 'execution_flag__release flag %L -', _flagname );

          _fullflagname varchar;
          _flagvalue    integer;

      BEGIN

          _fullflagname := 'myflag.' || _flagname || '_' || pg_backend_pid()::varchar;  -- Parameter müssen zwingend einen Punkt im Namen haben,
                                                                                        -- ... ansosnten wird folgende Fehlermeldung geworfen:
                                                                                        -- ERROR:  unrecognized configuration parameter "xyz"

          _flagvalue := set_config(
                              /*setting_name  =>*/ _fullflagname
                            , /*new_value     =>*/ ( coalesce( NullIf( current_setting( /*setting_name =>*/ _fullflagname, /*missing_ok =>*/ true ), '' )::integer, 0 ) - 1 )::varchar
                            , /*is_local      =>*/ true
                        );

          -- Debug
          IF _loglevel >= 5 THEN
              RAISE NOTICE '% fullname:%, value:%;', _prefix, _fullflagname, _flagvalue;
          END IF;

          RETURN;

      END $$ LANGUAGE plpgsql;


    /* Aktuellen Zustand des Ausführungsflags abfragen. */
    SELECT TSystem.function__drop_by_regex( 'execution_flag__isset', 'TSystem', _commit => true );
    CREATE OR REPLACE FUNCTION TSystem.execution_flag__isset(
          _flagname               varchar,              -- Name des Ausführungsflags
          _flagvalue_allowedmax   integer   DEFAULT 1,  -- Maximale Anzahl der verfügbaren parallelen
          _loglevel               int       DEFAULT TSystem.Log_Get_LogLevel( _user => 'yes' )
      ) RETURNS BOOL AS $$

      DECLARE

          _prefix       varchar := format( 'execution_flag__isset flag %L -', _flagname );

          _fullflagname varchar;
          _flagvalue    integer;

      BEGIN

          IF _flagvalue_allowedmax < 1 THEN
              RAISE EXCEPTION 'Parameter "_flagvalue_allowedmax" smaller 1 makes no sense!';
          END IF;

          _fullflagname := 'myflag.' || _flagname || '_' || pg_backend_pid()::varchar;  -- Parameter müssen zwingend einen Punkt im Namen haben,
                                                                                        -- ... ansosnten wird folgende Fehlermeldung geworfen:
                                                                                        -- ERROR:  unrecognized configuration parameter "xyz"

          _flagvalue = coalesce( NullIf( current_setting( /*setting_name =>*/ _fullflagname, /*missing_ok =>*/ true ), '' )::integer, 0 );

          -- Debug
          IF _loglevel >= 5 THEN
              RAISE NOTICE '% fullname:%, value:%;', _prefix, _fullflagname, _flagvalue;
          END IF;

          RETURN _flagvalue >= _flagvalue_allowedmax;

      END $$ LANGUAGE plpgsql;

-- Execution Flags Ende
